// AcMapOrclApiTestDescribeTableDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapOrclApiTestDescribeTableDlg

#include "stdafx.h"
#include "AcMapOrclApiTestDescribeTableDlg.h"
#include "AcMapOrclApiTestTools.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapOrclApiTestDescribeTableDlg dialog


//******************************************************************************************
AcMapOrclApiTestDescribeTableDlg::AcMapOrclApiTestDescribeTableDlg(
	const CString& strTableName,
	CWnd* pParent)
	: CDialog(AcMapOrclApiTestDescribeTableDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(AcMapOrclApiTestDescribeTableDlg)
	m_strTableDescription = _T("");
	m_strTableName = strTableName;
	//}}AFX_DATA_INIT
}


//******************************************************************************************
void AcMapOrclApiTestDescribeTableDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapOrclApiTestDescribeTableDlg)
	DDX_Control(pDX, IDC_EDIT_TABLE_NAME, m_editTableName);
	DDX_Control(pDX, IDC_EDIT_TABLE_DESCRIPTION, m_editTableDescription);
	DDX_Text(pDX, IDC_EDIT_TABLE_DESCRIPTION, m_strTableDescription);
	DDX_Text(pDX, IDC_EDIT_TABLE_NAME, m_strTableName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AcMapOrclApiTestDescribeTableDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapOrclApiTestDescribeTableDlg)
	ON_BN_CLICKED(IDC_BTN_DESCRIBE, OnBtnDescribe)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapOrclApiTestDescribeTableDlg message handlers

//******************************************************************************************
BOOL AcMapOrclApiTestDescribeTableDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_editTableDescription.SetTabStops(100);
	OnBtnDescribe();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//******************************************************************************************
bool AcMapOrclApiTestDescribeTableDlg::FillDescription()
{
	std::vector<std::string> vectColumnNames;
	std::vector<std::string> vectDataTypes;

	bool bResult=AcMapOrclApiTestTools::FillColumnNamesDataTypes(
		(const char*)m_strTableName,
		vectColumnNames,
		vectDataTypes,
		true);

	if (bResult)
	{
		m_strTableDescription="";
		for (int i=0; i<vectColumnNames.size(); i++)
		{
			m_strTableDescription+=vectColumnNames[i].c_str();
			m_strTableDescription+="\t";
			m_strTableDescription+=vectDataTypes[i].c_str();
			m_strTableDescription+="\r\n";
		}
	}

	return bResult;
}

//******************************************************************************************
void AcMapOrclApiTestDescribeTableDlg::OnBtnDescribe() 
{
	UpdateData(true);
	if (!m_strTableName.IsEmpty())
	{
		if (!FillDescription())
		{
			AfxMessageBox("Could not describe the table");
			return;
		}
	}
	UpdateData(false);
}

